/************************************************************************************
* Init platform
*
* Author(s): Jesper Thomsen
*
* (c) Copyright 2005, Freescale, Inc.  All rights reserved.
*
* Freescale Confidential Proprietary
* Digianswer Confidential
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
* Last Inspected:
* Last Tested:
************************************************************************************/
/*nothing needed here... yet*/

#ifndef _HPRFGW_RFPLATFORMINIT_H_
	#define _HPRFGW_RFPLATFORMINIT_H_

//#include "datatypes.h"
#include "hprfgw_rfSharedDefs.h"
/************************************************************************************
* Perform the complete GPIO port initialization
*
* Interface assumptions:
*
* Return value:
*   NONE
*
* Revision history:
*
*    Date    Author    Comments
*   ------   ------    --------
*   190505   JT        Created
*
************************************************************************************/
void PlatformPortInit(void);

/************************************************************************************
* Initialize platform specific stuff
* NVRAM, Bootloader, MC1319x driver etc.
*
* Interface assumptions:
*
*   NOTE!!! This First section of this function code is added to ensure that the symbols 
*   are included in the build. The linker will remove these symbols if not referenced.
*   Hope to find a better way 21.10.03 MVC 
*
* Return value:
*   NONE
*
* Revision history:
*
*    Date    Author    Comments
*   ------   ------    --------
*   030505   JT        Created
*
************************************************************************************/
void Platform_Init(void);


/************************************************************************************
* Initialize platform and stack. 
*
* This function is the main initialization procedure, which will be called from the 
* startup code of the project. 
* If the code is build as a stand-alone application, this function is
* called from main() below. 
*
* Interface assumptions:
*
* Return value:
*   NONE
*
* Revision history:
*
*    Date    Author    Comments
*   ------   ------    --------
*   030505   JT        Created
*
************************************************************************************/
void Init_802_15_4(UINT8 CCAEnergyDetectThr, UINT8 RSSIPowerCompOffset, UINT8 *pUID);


#ifdef  __cplusplus
extern "C" 
{
#endif

void RFReceive_TimerInitialize (void);
void RFReceive_Timer_HISR(void);
void RFReceive_Timer_LISR(int vector_num);
UINT16 RFReceive_DisableTimerInterrupt (void);
UINT16 RFReceive_EnableTimerInterrupt (void);
void RFReceive_MC13192PHY_LISR(int vector_num);
void RFReceive_StackInterruptConfig (void);
UINT16	RFReceive_GetTimerValue (void);
void RFReceive_TimerPowerDown(void);
void RFReceive_TimerPowerUp(void);

#ifdef  __cplusplus
}
#endif


#endif /* _PLATFORMINIT_H_  */ 
